/*
 * Decompiled with CFR 0.152.
 */
package spaceprotect;

import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexBuffer;
import spaceprotect.Game;
import spaceprotect.Objects3D;
import spaceprotect.Vector3D;

public class Stars {
    private Vector stars = new Vector();
    private VertexBuffer starVertexData = null;
    private TriangleStripArray starTriangles = null;
    private Appearance starAppearance;
    private Transform starMatrix;

    public Stars(Game game, int count) {
        for (int i = 0; i < count; ++i) {
            this.stars.addElement(new Vector3D(game.r.nextFloat() * 250.0f - 125.0f, game.r.nextFloat() * 450.0f - 50.0f, game.r.nextFloat() * 250.0f - 125.0f));
        }
        if (this.starVertexData == null) {
            float[] graf = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 2.0f, 0.0f};
            this.starVertexData = new VertexBuffer();
            this.starTriangles = Objects3D.buildRotateGraf(this.starVertexData, 2, graf);
        }
        this.starAppearance = new Appearance();
        this.starMatrix = new Transform();
    }

    public void update(float time_frame) {
        for (int i = 0; i < this.stars.size(); ++i) {
            Vector3D s = (Vector3D)this.stars.elementAt(i);
            s.y -= 500.0f * time_frame;
            if (!(s.y < -50.0f)) continue;
            s.y = 400.0f;
        }
    }

    public void paint(Graphics3D g3d) {
        for (int i = 0; i < this.stars.size(); ++i) {
            Vector3D s = (Vector3D)this.stars.elementAt(i);
            this.starMatrix.setIdentity();
            this.starMatrix.postTranslate(s.x, s.y, s.z);
            this.starMatrix.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
            this.starMatrix.postRotate(90.0f, 1.0f, 0.0f, 0.0f);
            g3d.render(this.starVertexData, (IndexBuffer)this.starTriangles, this.starAppearance, this.starMatrix);
        }
    }
}

