/*
 * Decompiled with CFR 0.152.
 */
package spaceprotect;

import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import spaceprotect.Vector3D;

public class Objects3D {
    private static final byte[] VERTEX_POSITIONS = new byte[]{-1, -1, 1, 1, -1, 1, -1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, 1, 1, -1, -1, 1, -1, 1, -1, 1, 1, -1, -1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, 1, -1, 1, -1, -1, 1, 1, -1, 1, 1, 1, 1, 1, -1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, -1, -1, -1, 1, 1, -1, 1};
    private static final int[] TRIANGLE_INDICES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static int[] TRIANGLE_LENGTHS = new int[]{4, 4, 4, 4, 4, 4};

    private static byte[] calcNormals(byte[] vp, int[] ti, int[] tl) {
        byte[] normals = new byte[vp.length];
        int begin = 0;
        for (int i = 0; i < tl.length; ++i) {
            for (int j = 2; j < tl[i]; ++j) {
                int bi = begin + j;
                int ia = ti[bi];
                int ib = ti[bi - 1];
                int ic = ti[bi - 2];
                Vector3D a = new Vector3D(vp[ia * 3], vp[ia * 3 + 1], vp[ia * 3 + 2]);
                Vector3D b = new Vector3D(vp[ib * 3], vp[ib * 3 + 1], vp[ib * 3 + 2]);
                Vector3D c = new Vector3D(vp[ic * 3], vp[ic * 3 + 1], vp[ic * 3 + 2]);
                Vector3D d = new Vector3D(a);
                d.Sub(b);
                Vector3D e = new Vector3D(a);
                e.Sub(c);
                Vector3D f = j == 2 ? Vector3D.Cross(d, e, new Vector3D()) : Vector3D.Cross(e, d, new Vector3D());
                f.Unit();
                byte nx = (byte)(f.x * 127.0f);
                byte ny = (byte)(f.y * 127.0f);
                byte nz = (byte)(f.z * 127.0f);
                normals[ia * 3] = nx;
                normals[ia * 3 + 1] = ny;
                normals[ia * 3 + 2] = nz;
                if (j != 2) continue;
                normals[ib * 3] = nx;
                normals[ib * 3 + 1] = ny;
                normals[ib * 3 + 2] = nz;
                normals[ic * 3] = nx;
                normals[ic * 3 + 1] = ny;
                normals[ic * 3 + 2] = nz;
            }
            begin += tl[i];
        }
        return normals;
    }

    private static TriangleStripArray prepareObject(byte[] vp, int[] ti, int[] tl, VertexBuffer vertexData) {
        VertexArray vertexPositions = new VertexArray(vp.length / 3, 3, 1);
        vertexPositions.set(0, vp.length / 3, vp);
        vertexData.setPositions(vertexPositions, 1.0f, null);
        byte[] vn = Objects3D.calcNormals(vp, ti, tl);
        VertexArray vertexNormals = new VertexArray(vn.length / 3, 3, 1);
        vertexNormals.set(0, vn.length / 3, vn);
        vertexData.setNormals(vertexNormals);
        return new TriangleStripArray(ti, tl);
    }

    public static void calcPyramid(byte[] vp, int[] ti, int[] tl, int start, int sides, float down, float downr, float up, float upr) {
        int i;
        double dsides = sides;
        for (i = 0; i < sides; ++i) {
            int start_index = (i + start) * 12;
            vp[start_index] = (byte)(Math.sin((double)i / dsides * Math.PI * 2.0) * (double)downr);
            vp[start_index + 1] = (byte)(Math.cos((double)i / dsides * Math.PI * 2.0) * (double)downr);
            vp[start_index + 2] = (byte)down;
            vp[start_index + 3] = (byte)(Math.sin(((double)i + 1.0) / dsides * Math.PI * 2.0) * (double)downr);
            vp[start_index + 4] = (byte)(Math.cos(((double)i + 1.0) / dsides * Math.PI * 2.0) * (double)downr);
            vp[start_index + 5] = (byte)down;
            vp[start_index + 6] = (byte)(Math.sin((double)i / dsides * Math.PI * 2.0) * (double)upr);
            vp[start_index + 7] = (byte)(Math.cos((double)i / dsides * Math.PI * 2.0) * (double)upr);
            vp[start_index + 8] = (byte)up;
            vp[start_index + 9] = (byte)(Math.sin(((double)i + 1.0) / dsides * Math.PI * 2.0) * (double)upr);
            vp[start_index + 10] = (byte)(Math.cos(((double)i + 1.0) / dsides * Math.PI * 2.0) * (double)upr);
            vp[start_index + 11] = (byte)up;
            tl[start + i] = 4;
        }
        for (i = 0; i < sides * 4; ++i) {
            ti[start * 4 + i] = start * 4 + i;
        }
    }

    public static TriangleStripArray buildRotateGraf(VertexBuffer vertexData, int sides, float[] graf) {
        int graf_length = graf.length / 2;
        byte[] vp = new byte[sides * 12 * (graf_length - 1)];
        int[] ti = new int[sides * 4 * (graf_length - 1)];
        int[] tl = new int[sides * (graf_length - 1)];
        double dsides = sides;
        for (int i = 1; i < graf_length; ++i) {
            Objects3D.calcPyramid(vp, ti, tl, sides * (i - 1), sides, graf[(i - 1) * 2], graf[(i - 1) * 2 + 1], graf[i * 2], graf[i * 2 + 1]);
        }
        return Objects3D.prepareObject(vp, ti, tl, vertexData);
    }

    public static TriangleStripArray buildPyramid(VertexBuffer vertexData, int sides, float down, float downr, float up, float upr) {
        float[] graf = new float[]{down, downr, up, upr};
        return Objects3D.buildRotateGraf(vertexData, sides, graf);
    }

    public static TriangleStripArray buildDoublePyramid(VertexBuffer vertexData, int sides, float down, float downr, float mid, float midr, float up, float upr) {
        float[] graf = new float[]{down, downr, mid, midr, up, upr};
        return Objects3D.buildRotateGraf(vertexData, sides, graf);
    }

    public static TriangleStripArray buildBox(VertexBuffer vertexData) {
        return Objects3D.prepareObject(VERTEX_POSITIONS, TRIANGLE_INDICES, TRIANGLE_LENGTHS, vertexData);
    }
}

