/*
 * Decompiled with CFR 0.152.
 */
package spaceprotect;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Transform;
import spaceprotect.EnemyShip1;
import spaceprotect.GameObject;
import spaceprotect.Main;
import spaceprotect.PlayerShip;
import spaceprotect.Shot1;
import spaceprotect.Sound;
import spaceprotect.Sprite;
import spaceprotect.Stars;
import spaceprotect.Vector3D;

public class Game
extends Canvas
implements CommandListener {
    private Main app;
    private Graphics3D g3d;
    private Camera camera;
    private Transform cameraTransform;
    private Light light;
    Vector sv;
    Stars stars;
    private long begin_time;
    private float time_frame;
    private float memory_fps;
    private float average_fps;
    private int counter_fps;
    private Font game_font;
    private int fontHeight;
    private int anchor;
    private int w;
    private int h;
    boolean[] keys;
    public int counter;
    public int bulletShift;
    public int escapes;
    public Random r = new Random();
    private Timer refreshTimer;
    private Command exitCommand = new Command("Exit", 7, 1);
    static /* synthetic */ Class class$spaceprotect$Shot1;
    static /* synthetic */ Class class$spaceprotect$EnemyShip1;

    public Game(Main app) {
        this.app = app;
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
        this.setFullScreenMode(true);
        this.time_frame = 0.0f;
        this.memory_fps = 0.0f;
        this.average_fps = 0.0f;
        this.counter_fps = 0;
        this.keys = new boolean[60];
        this.counter = 0;
    }

    public void showNotify() {
        this.g3d = Graphics3D.getInstance();
        this.camera = new Camera();
        float aspect = (float)this.getWidth() / (float)this.getHeight();
        this.camera.setPerspective(30.0f, aspect, 1.0f, 1000.0f);
        this.cameraTransform = new Transform();
        this.cameraTransform.postTranslate(0.0f, -370.0f, 300.0f);
        this.cameraTransform.postRotate(57.0f, 1.0f, 0.0f, 0.0f);
        this.g3d.setCamera(this.camera, this.cameraTransform);
        this.light = new Light();
        this.light.setMode(129);
        this.light.setColor(0xFFFFFF);
        this.light.setIntensity(1.0f);
        Transform lightTransform = new Transform();
        lightTransform.postTranslate(0.0f, 0.0f, 3.0f);
        Light light2 = new Light();
        light2.setMode(130);
        light2.setColor(34816);
        light2.setIntensity(1.0f);
        Transform lightTransform2 = new Transform();
        lightTransform2.postTranslate(0.0f, 100.0f, 3.0f);
        this.g3d.resetLights();
        this.g3d.addLight(this.light, lightTransform);
        this.sv = new Vector();
        this.sv.addElement(new PlayerShip(this));
        this.stars = new Stars(this, 20);
        this.anchor = 20;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.begin_time = System.currentTimeMillis();
        this.refreshTimer = new Timer();
        this.refreshTimer.schedule(new TimerTask(){

            public void run() {
                Game.this.repaint();
            }
        }, 0L, 20L);
    }

    protected void paint(Graphics graphics) {
        long start_time = System.currentTimeMillis();
        if (this.counter % 50 == 0) {
            this.sv.addElement(new EnemyShip1(this, new Vector3D(this.r.nextFloat() * 200.0f - 100.0f, 600.0f, 0.0f), Math.abs(this.r.nextInt()) % 7));
        }
        ++this.counter;
        int i = 0;
        while (i < this.sv.size()) {
            GameObject go = (GameObject)this.sv.elementAt(i);
            if (go.update(this.time_frame, this.keys)) {
                this.sv.removeElement(go);
                continue;
            }
            for (int j = 0; j < this.sv.size(); ++j) {
                float delta_y;
                float delta_x;
                float dist;
                GameObject go2 = (GameObject)this.sv.elementAt(j);
                if (!go.getClass().isAssignableFrom(class$spaceprotect$Shot1 == null ? Game.class$("spaceprotect.Shot1") : class$spaceprotect$Shot1) || !go2.getClass().isAssignableFrom(class$spaceprotect$EnemyShip1 == null ? Game.class$("spaceprotect.EnemyShip1") : class$spaceprotect$EnemyShip1) || !((dist = (float)Math.sqrt((delta_x = ((Sprite)((Object)go2)).p.x - ((Sprite)((Object)go)).p.x) * delta_x + (delta_y = ((Sprite)((Object)go2)).p.y - ((Sprite)((Object)go)).p.y) * delta_y)) < ((Sprite)((Object)go)).r + ((Sprite)((Object)go2)).r)) continue;
                if (((Shot1)go).type == ((EnemyShip1)go2).type) {
                    this.sv.removeElement(go2);
                    Sound.PlaySound1();
                }
                this.sv.removeElement(go);
                i = -1;
                break;
            }
            ++i;
        }
        this.stars.update(this.time_frame);
        this.g3d.bindTarget((Object)graphics);
        this.g3d.clear(null);
        for (i = 0; i < this.sv.size(); ++i) {
            ((GameObject)this.sv.elementAt(i)).paint(this.g3d);
        }
        this.stars.paint(this.g3d);
        this.g3d.releaseTarget();
        graphics.setColor(-1);
        long mspf = System.currentTimeMillis() - start_time + 20L;
        this.game_font = graphics.getFont();
        this.fontHeight = this.game_font.getHeight();
        float fps = 1000.0f / (float)mspf;
        this.average_fps += fps;
        if (this.counter_fps != 0) {
            this.average_fps /= 2.0f;
        }
        if (this.counter_fps % 10 == 0) {
            this.memory_fps = this.average_fps;
            this.average_fps = fps;
        }
        ++this.counter_fps;
        graphics.drawString("FPS: " + String.valueOf((float)((int)(this.memory_fps * 100.0f)) / 100.0f), 0, 0, this.anchor);
        graphics.drawString(String.valueOf(this.escapes), this.w, this.h, 40);
        long game_time = System.currentTimeMillis() - this.begin_time;
        graphics.drawString(String.valueOf(game_time / 60000L) + ":" + String.valueOf(game_time % 60000L / 1000L), 0, this.h, 36);
        String kali_web = "www.kali.wz.cz";
        graphics.drawString(kali_web, this.w - this.game_font.stringWidth(kali_web), 0, this.anchor);
        this.time_frame = (float)mspf / 1000.0f;
    }

    protected void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (action < 60) {
            this.keys[action] = true;
        }
        if (this.getGameAction(keyCode) == 1) {
            ++this.bulletShift;
        }
    }

    protected void keyReleased(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (action < 60) {
            this.keys[action] = false;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.app.quit();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

