/*
 * Decompiled with CFR 0.152.
 */
package spaceprotect;

public class Vector {
    public float x;
    public float y;
    public float z;

    public Vector() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void Set(Vector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void Add(Vector v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void Sub(Vector v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void Unit() {
        float length = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public void Invert() {
        this.x *= -1.0f;
        this.y *= -1.0f;
        this.z *= -1.0f;
    }

    public static Vector Cross(Vector a, Vector b, Vector result) {
        result.x = a.y * b.z - a.z * b.y;
        result.y = a.z * b.x - a.x * b.z;
        result.z = a.x * b.y - a.y * b.x;
        return result;
    }
}

