/*
 * Decompiled with CFR 0.152.
 */
package spaceprotect;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexBuffer;
import spaceprotect.Objects3D;

public class Game
extends Canvas {
    private Graphics3D g3d;
    private Camera camera;
    private Transform cameraTransform;
    private Light light;
    private Transform matrix;
    private VertexBuffer cubeVertexData;
    private TriangleStripArray cubeTriangles;
    private Appearance cubeAppearance;
    private float angel;
    private float angel2;
    private float step;
    private float time_frame;
    private float memory_fps;
    private float average_fps;
    private int counter_fps;
    private Font game_font;
    private int fontHeight;
    private int anchor;
    private int w;
    private int h;
    boolean[] keys;
    private Timer refreshTimer;

    public void showNotify() {
        this.g3d = Graphics3D.getInstance();
        this.camera = new Camera();
        float aspect = (float)this.getWidth() / (float)this.getHeight();
        this.camera.setPerspective(30.0f, aspect, 1.0f, 1000.0f);
        this.cameraTransform = new Transform();
        this.cameraTransform.postTranslate(0.0f, 0.0f, 500.0f);
        this.g3d.setCamera(this.camera, this.cameraTransform);
        this.light = new Light();
        this.light.setMode(129);
        this.light.setColor(65535);
        this.light.setIntensity(1.0f);
        Transform lightTransform = new Transform();
        lightTransform.postTranslate(0.0f, 0.0f, 3.0f);
        Light light2 = new Light();
        light2.setMode(130);
        light2.setColor(34816);
        light2.setIntensity(1.0f);
        Transform lightTransform2 = new Transform();
        lightTransform2.postTranslate(0.0f, 100.0f, 3.0f);
        this.g3d.resetLights();
        this.g3d.addLight(this.light, lightTransform);
        this.g3d.addLight(light2, lightTransform2);
        this.matrix = new Transform();
        float[] graf = new float[20];
        for (int i = 0; i < 20; i += 2) {
            graf[i] = (float)i * 5.0f + 20.0f;
            graf[i + 1] = (float)(Math.sin((double)i / 2.0) * 25.0 + 70.0);
        }
        this.cubeVertexData = new VertexBuffer();
        this.cubeTriangles = Objects3D.buildRotateGraf(this.cubeVertexData, 40, graf);
        this.cubeAppearance = new Appearance();
        Material material = new Material();
        material.setColor(8192, 0);
        material.setShininess(1.0f);
        this.cubeAppearance.setMaterial(material);
        PolygonMode pm = new PolygonMode();
        pm.setCulling(161);
        this.cubeAppearance.setPolygonMode(pm);
        this.angel = 0.0f;
        this.angel2 = 90.0f;
        this.step = 0.0f;
        this.time_frame = 0.0f;
        this.memory_fps = 0.0f;
        this.average_fps = 0.0f;
        this.counter_fps = 0;
        this.anchor = 20;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.keys = new boolean[60];
        this.refreshTimer = new Timer();
        this.refreshTimer.schedule(new TimerTask(){

            public void run() {
                Game.this.repaint();
            }
        }, 0L, 20L);
    }

    protected void paint(Graphics graphics) {
        long start_time = System.currentTimeMillis();
        this.g3d.bindTarget((Object)graphics);
        this.g3d.clear(null);
        this.g3d.render(this.cubeVertexData, (IndexBuffer)this.cubeTriangles, this.cubeAppearance, this.matrix);
        this.matrix.postRotate(1.5707964f, 1.0f, 0.0f, 0.0f);
        this.matrix.invert();
        this.g3d.render(this.cubeVertexData, (IndexBuffer)this.cubeTriangles, this.cubeAppearance, this.matrix);
        if (this.keys[2] || this.keys[5]) {
            if (this.keys[5]) {
                this.step = 30.0f;
            }
            if (this.keys[2]) {
                this.step = -30.0f;
            }
        } else {
            this.step = 0.0f;
        }
        this.angel += 30.0f * this.time_frame;
        this.angel2 += this.step * this.time_frame;
        this.matrix.setIdentity();
        this.matrix.postRotate(this.angel, 0.0f, 0.0f, 1.0f);
        this.matrix.postRotate(this.angel2, 0.0f, 1.0f, 0.0f);
        this.g3d.releaseTarget();
        graphics.setColor(-1);
        long mspf = System.currentTimeMillis() - start_time + 20L;
        this.game_font = graphics.getFont();
        this.fontHeight = this.game_font.getHeight();
        float fps = 1000.0f / (float)mspf;
        this.average_fps += fps;
        if (this.counter_fps != 0) {
            this.average_fps /= 2.0f;
        }
        if (this.counter_fps % 10 == 0) {
            this.memory_fps = this.average_fps;
            this.average_fps = fps;
        }
        ++this.counter_fps;
        graphics.drawString("FPS: " + String.valueOf((float)((int)(this.memory_fps * 100.0f)) / 100.0f), 0, 0, this.anchor);
        graphics.drawString("Screen size: " + this.w + "*" + this.h + "px", 0, this.fontHeight, this.anchor);
        graphics.drawString("Exit", 0, this.h - this.fontHeight, this.anchor);
        String kali_web = "www.kali.wz.cz";
        graphics.drawString(kali_web, this.w - this.game_font.stringWidth(kali_web), 0, this.anchor);
        this.time_frame = (float)mspf / 1000.0f;
    }

    protected void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (action < 60) {
            this.keys[action] = true;
        }
    }

    protected void keyReleased(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (action < 60) {
            this.keys[action] = false;
        }
    }
}

