#include <windows.h>	// Knihovna Windows
#include <stdio.h>		// Knihovna "Standard Input Output"
#include "resource.h"	// Hlavika s zdrojovmi daty

#define WP		20		// ka jednoho polka v pixelech
#define HP		20		// Dlka jednoho polka v pixelech
#define RM		7		// Polomr miny p pixelech
#define RI		6		// Polomr znaky miny

#define SM_NONE	0x00	// Znamen, e na polku nen mina
#define SM_MINE	0x01	// Znamen, e na polku je mina
#define SM_DONE	0x02	// Znamen, e mapa je odkryt

typedef struct {		// Struktra s informacemi o polku
	int		pmo;		// Poet min okolo [-1 znamen, e je na nm mina]
	bool	v;			// Vodkryto?
	char	is;			// Informacn stav
} POLE, *PPOLE;

HWND		g_hWnd			= NULL; // Rukoje okna
HDC			g_hClientDC		= NULL; // Rukoje grafickho prosted okna
HDC			g_hDC			= NULL; // Rukoje pomocnho grafickho prosted
HBITMAP		g_hBitmap		= NULL; // Rukoje pomocn bitmapy
HBRUSH		g_hb1			= NULL; // Rukoje svtleedho pozad
HBRUSH		g_hb2			= NULL; // Rukoje tmavedho pozad
HBRUSH		g_hb3			= NULL; // Rukoje ervenho pozad
HPEN		g_hp1			= NULL; // Rukoje svtleedho pera

DWORD		g_colors[12];

PPOLE		g_m				= NULL;	// Ukazatel na pole polek [mapa min]
int			*g_m2			= NULL; // Ukazatel na pole index postupn odkrvajcch se polek
int			g_mw			= 0;	// ka minovho pole
int			g_mh			= 0;	// Dlha minovho pole
int			g_pi			= 0;	// Poet index poli pro dal odkryt
int			g_pm			= 0;	// Poet min v minovm poly

SYSTEMTIME	g_start_time;			// Struktura s asem pi startu
int			g_delta_time	= 0;	// Doba hran

bool		g_quit	= false;		// Vrok pro ukonen programu

LRESULT CALLBACK MainWndProc (HWND hwnd,	// Prototyp funkce pro systm sprv Windows
	UINT uMsg, WPARAM wParam, LPARAM lParam);
void CreateMap (int w, int h, int pm);		// Prototyp funkce pro vytvoen minovho pole
void FreeMap ();							// ... pro uvolnn mapy
char StepMap (int x, int y);				// ... pro krok v poly [vstupn hodnoty jsou nahoe]
void DrawMap ();							// ... pro vykreslen pole
void DrawCap (bool must_redraw_now);		// ... pro vykreslen titulku okna
void RetryGame ();							// ... pro dotaz na opakovn hry

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst,
				   LPSTR lpCmdLine, int nCmdShow)
{
	GetSystemTime (&g_start_time);

	DEVMODE dm;
	RECT wr;

	int w, h, pm;
	FILE *f = fopen ("Miny.ini", "rt");
	if (f)
	{
		bool is_all_right =
			fscanf (f, "width = %d\n", &w) &&
			fscanf (f, "height = %d\n", &h) &&
			fscanf (f, "mines count = %d\n", &pm) &&
			fscanf (f, "backcolor = %X\n", &g_colors[0]) &&
			fscanf (f, "backcolor2 = %X\n", &g_colors[1]) &&
			fscanf (f, "rastercolor = %X\n", &g_colors[2]) &&
			fscanf (f, "minecolor = %X\n", &g_colors[3]) &&
			fscanf (f, "pmocolor1 = %X\n", &g_colors[4]) &&
			fscanf (f, "pmocolor2 = %X\n", &g_colors[5]) &&
			fscanf (f, "pmocolor3 = %X\n", &g_colors[6]) &&
			fscanf (f, "pmocolor4 = %X\n", &g_colors[7]) &&
			fscanf (f, "pmocolor5 = %X\n", &g_colors[8]) &&
			fscanf (f, "pmocolor6 = %X\n", &g_colors[9]) &&
			fscanf (f, "pmocolor7 = %X\n", &g_colors[10]) &&
			fscanf (f, "pmocolor8 = %X", &g_colors[11]);

		fclose (f);

		if (is_all_right)
		{
			if (w < 6 || h < 6)
				MessageBox (NULL, "Minimln ka i dlka mus bt 6 polek.", "Upozornn", MB_ICONWARNING);

			if (w < 6)
				w = 6;
			if (h < 6)
				h = 6;

			bool corect_map_size = false;

			EnumDisplaySettings (NULL, ENUM_CURRENT_SETTINGS, &dm);

			resize_map:

			wr.left = 0;
			wr.top = 0;
			wr.right = w * WP;
			wr.bottom = h * HP;

			AdjustWindowRect (&wr, WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, false);

			if ((DWORD) (wr.right - wr.left) > dm.dmPelsWidth)
			{
				w--;
				corect_map_size = true;
				goto resize_map;
			}

			if ((DWORD) (wr.bottom - wr.top) > dm.dmPelsHeight)
			{
				h--;
				corect_map_size = true;
				goto resize_map;
			}

			if (corect_map_size)
				MessageBox (NULL, "Velikost mapy musela bt zmenena.", "Upozornn", MB_ICONWARNING);

			if (w * h > pm)
				CreateMap (w, h, pm);
			else
			{
				MessageBox (NULL, "Velikost minovho pole mus bt vt,\nne je poet min!", "Chyba", MB_ICONERROR);
				return 1;
			}
		}
		else
		{
			MessageBox (NULL, "Soubor \"Miny.ini\" je patn zadan.", "Chyba", MB_ICONERROR);
			return 1;
		}
	}
	else
	{
		MessageBox (NULL, "Nelze najit soubor Miny.ini.", "Chyba", MB_ICONERROR);
		return 1;
	}

	WNDCLASS wc;
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInst;
	wc.hIcon = LoadIcon (hInst, MAKEINTRESOURCE(IDI_MAIN));
	wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) GetStockObject (LTGRAY_BRUSH);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "Class Miny";
	RegisterClass (&wc);

	g_hWnd = CreateWindow ("Class Miny", NULL, WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
		(dm.dmPelsWidth - wr.right + wr.left) / 2,
		(dm.dmPelsHeight - wr.bottom + wr.top) / 2,
		wr.right - wr.left, wr.bottom - wr.top, NULL, NULL, hInst, NULL);

	ShowWindow (g_hWnd, SW_SHOW);
	SetForegroundWindow (g_hWnd);
	SetFocus (g_hWnd);

	g_hClientDC = GetDC (g_hWnd);
	g_hDC = CreateCompatibleDC (g_hClientDC);
	g_hBitmap = CreateCompatibleBitmap (g_hClientDC, w * WP, h * HP);
	SelectObject (g_hDC, g_hBitmap);

	g_hb1 = CreateSolidBrush (g_colors[0]);
	g_hb2 = CreateSolidBrush (g_colors[1]);
	g_hb3 = CreateSolidBrush (g_colors[3]);
	g_hp1 = CreatePen (PS_SOLID, 1, g_colors[2]);

	SetBkMode (g_hDC, TRANSPARENT);

	while (!g_quit)
	{
		MSG msg;
		if (PeekMessage (&msg, g_hWnd, 0, 0, PM_REMOVE))
		{
			TranslateMessage (&msg);
			DispatchMessage (&msg);
		}
		else
			DrawCap (false);
	}

	DeleteObject (g_hp1);
	DeleteObject (g_hb3);
	DeleteObject (g_hb2);
	DeleteObject (g_hb1);

	DeleteObject (g_hBitmap);
	DeleteDC (g_hDC);
	ReleaseDC (g_hWnd, g_hClientDC);

	DestroyWindow (g_hWnd);

	UnregisterClass ("Class Miny", hInst);

	FreeMap ();

	return 0;
}

LRESULT CALLBACK MainWndProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_CLOSE:
		g_quit = true;
		break;

	case WM_LBUTTONDOWN:
	{
		char res_step = StepMap ((LOWORD(lParam)) / HP, (HIWORD(lParam)) / WP);
		char str[256];
		DrawMap ();

		switch (res_step)
		{
		case SM_MINE: sprintf (str, "lpnul jste na minu!"); break;
		case SM_DONE: sprintf (str, "Gratuluji, nali jste vechny miny za %d sekund.", g_delta_time);
		}

		if (res_step != SM_NONE)
		{
			MessageBox (g_hWnd, str, "Miny", MB_ICONINFORMATION);
			RetryGame ();
		}
	}
		break;

	case WM_RBUTTONDOWN:
	{
		int ind = ((HIWORD(lParam)) / HP) * g_mw + ((LOWORD(lParam)) / WP);

		g_m[ind].is++;
		g_m[ind].is %= 3;
	}

	case WM_PAINT:
		DrawMap ();
		DrawCap (true);
	}

	return DefWindowProc (hWnd, uMsg, wParam, lParam);
}

void CreateMap (int w, int h, int pm)
{
	g_mw = w;
	g_mh = h;
	g_pm = pm;

	g_m = (PPOLE) malloc (w * h * sizeof (POLE));
	g_m2 = (int *) malloc (w * h * sizeof (int));

	memset (g_m, 0, w * h * sizeof (POLE));
	memset (g_m2, 0, w * h * sizeof (int));

	for (int i = 0; i < pm; i++)
	{
		int ind = rand () % (w * h);
		if (g_m[ind].pmo != -1)
			g_m[ind].pmo = -1;
		else
			i--;
	}

	for (int i = 0; i < h; i++)
		for (int n = 0; n < w; n++)
			for (int j = i - 1; j <= i + 1; j++)
				for (int k = n - 1; k <= n + 1; k++)
					if (g_m[i * w + n].pmo != -1 &&
						j >= 0 && j < h &&
						k >= 0 && k < w &&
						g_m[j * w + k].pmo == -1)
						g_m[i * w + n].pmo++;
}

void FreeMap ()
{
	if (g_m)
	{
		free (g_m);
		g_m = NULL;
	}

	if (g_m2)
	{
		free (g_m2);
		g_m2 = NULL;
	}
}

char StepMap (int x, int y)
{
	int ind = y * g_mw + x;

	if (g_m[ind].is != 1)
		if (g_m[ind].pmo != -1)
		{
			g_m[ind].v = true;

			if (g_m[ind].pmo == 0)
			{
				g_m2[0] = ind;
				g_pi = 1;

				while (g_pi > 0)
				{
					int x = g_m2[0] % g_mw,
						y = g_m2[0] / g_mw;

					for (int i = y - 1; i <= y + 1; i++)
						for (int n = x - 1; n <= x + 1; n++)
							if (i >= 0 && i < g_mh && n >= 0 && n < g_mw)
							{
								ind = i * g_mw + n;

								if (!g_m[ind].v)
								{
									g_m[ind].v = true;

									if (g_m[ind].pmo == 0)
									{
										bool not_exists = true;
										for (int k = 0; k < g_pi; k++)
											if (g_m2[k] == ind)
											{
												not_exists = false;
												break;
											}

										if (not_exists)
										{
											g_m2[g_pi] = ind;
											g_pi++;
										}
									}
								}
							}

					g_pi--;
					g_m2[0] = g_m2[g_pi];
				}
			}

			bool level_complete = true;
			for (int i = 0; i < g_mw * g_mh; i++)
				if (g_m[i].pmo >= 0 && !g_m[i].v)
				{
					level_complete = false;
					break;
				}

			if (level_complete)
			{
				for (int i = 0; i < g_mw * g_mh; i++)
					if (g_m[i].pmo == -1)
						g_m[i].is = 1;
					
				return SM_DONE;
			}
		}
		else
		{
			for (int i = 0; i < g_mw * g_mh; i++)
				g_m[i].v = true;

			return SM_MINE;
		}

	return SM_NONE;
}

void DrawMap ()
{
	for (int i = 0; i < g_mh; i++)
		for (int n = 0; n < g_mw; n++)
		{
			int	ind = i * g_mw + n,
				pmo = g_m[ind].pmo;
			bool  v = g_m[ind].v;
			char is = g_m[ind].is;

			if (v)
			{
				SelectObject (g_hDC, g_hb1);
				SelectObject (g_hDC, g_hp1);
				Rectangle (g_hDC,	n * WP,
									i * HP,
									n * WP + WP,
									i * HP + HP);

				if (pmo != 0)
					if (pmo == -1)
					{
						SelectObject (g_hDC, g_hb3);
						Ellipse (g_hDC, n * WP + WP / 2 - RM,
										i * HP + HP / 2 - RM,
										n * WP + WP / 2 + RM,
										i * HP + HP / 2 + RM);
					}
					else
					{
						switch (pmo)
						{
						case 1: SetTextColor (g_hDC, g_colors[4]); break;
						case 2: SetTextColor (g_hDC, g_colors[5]); break;
						case 3: SetTextColor (g_hDC, g_colors[6]); break;
						case 4: SetTextColor (g_hDC, g_colors[7]); break;
						case 5: SetTextColor (g_hDC, g_colors[8]); break;
						case 6: SetTextColor (g_hDC, g_colors[9]); break;
						case 7: SetTextColor (g_hDC, g_colors[10]); break;
						case 8: SetTextColor (g_hDC, g_colors[11]); break;
						}

						char str[256];
						sprintf (str, "%d", pmo);

						SIZE s;
						GetTextExtentPoint32 (g_hDC, str, strlen (str), &s);

						TextOut (g_hDC, n * WP + (WP - s.cx) / 2,
										i * HP + (HP - s.cy) / 2, str, strlen(str));
					}
			}
			else
			{
				SelectObject (g_hDC, g_hb2);
				SelectObject (g_hDC, GetStockObject (BLACK_PEN));
				Rectangle (g_hDC,	n * WP,
									i * HP,
									n * WP + WP,
									i * HP + HP);

				SelectObject (g_hDC, GetStockObject (WHITE_PEN));
				MoveToEx (g_hDC,	n * WP,
									i * HP + HP, NULL);
				LineTo (g_hDC,		n * WP,
									i * HP);
				LineTo (g_hDC,		n * WP + WP,
									i * HP);

				if (is != 0)
				{
					char str[2];
					str[1] = 0;

					if (is == 1)
					{
						str[0] = '!';
						SetTextColor (g_hDC, 0x0000FF);
					}
					else
					{
						str[0] = '?';
						SetTextColor (g_hDC, 0xFF0000);
					}

					SIZE s;
					GetTextExtentPoint32 (g_hDC, str, 1, &s);
					TextOut (g_hDC, n * WP + (WP - s.cx) / 2, i * HP + (HP - s.cy) / 2, str, strlen(str));
				}
			}
		}

	BitBlt (g_hClientDC, 0, 0, g_mw * WP, g_mh * HP, g_hDC, 0, 0, SRCCOPY);
}

void DrawCap (bool must_redraw_now)
{
	int zpm = 0;
	for (int i = 0; i < g_mw * g_mh; i++)
		if (g_m[i].is == 1 && !g_m[i].v)
			zpm++;
	zpm = g_pm - zpm;

	bool invert = false;
	if (zpm < 0)
	{
		zpm *= -1;
		invert = true;
	}

	char *str_m;

	if (zpm == 0 || zpm > 4)
		str_m = "min";
	if (zpm == 1)
		str_m = "minu";
	if (zpm > 1 && zpm < 5)
		str_m = "miny";

	if (invert)
		zpm *= -1;

	SYSTEMTIME now_time;
	GetSystemTime (&now_time);
	int delta_time = (now_time.wHour - g_start_time.wHour) * 3600 +
		(now_time.wMinute - g_start_time.wMinute) * 60 +
		now_time.wSecond - g_start_time.wSecond;

	char str[256];
	sprintf (str, "Hledn min [zbv najt %d %s, as %d]", zpm, str_m, delta_time);

	if (delta_time != g_delta_time || must_redraw_now)
	{
		g_delta_time = delta_time;
		SetWindowText (g_hWnd, str);
	}
}

void RetryGame ()
{
	if (MessageBox (g_hWnd, "Chcete hrt znova?", "Miny", MB_ICONQUESTION | MB_YESNO) == IDNO)
		g_quit = true;
	else
	{
		FreeMap ();
		CreateMap (g_mw, g_mh, g_pm);
		DrawMap ();

		g_delta_time = 0;
		GetSystemTime (&g_start_time);
		DrawCap (true);
	}
}
