/*
  Project: Kali Versatile Scroll Bars
  Version: 1.01
  
  Author: Jirka Kalina
  URL: www.kali.wz.cz
  Email: kallii@seznam.cz
  Inspiration: www.dyn-web.com
  
  Please don't modify this file
*/

var KVScrollBar = {
  obj: null,
  posChanged: false,
  onStartShift: null,
  onChange: null,
  onEndShift: null,
  
  create: function(trackid, length, view, anchor, anchor2, stepping, passive, axis) {
    KVScrollBar.obj = document.createElement("div");
    KVScrollBar.obj.track = document.getElementById(trackid);
    KVScrollBar.obj.activated = false;
    KVScrollBar.obj.vertical = axis == "v";
    KVScrollBar.obj.anch = anchor;
    KVScrollBar.obj.anch2 = anchor2;
    KVScrollBar.obj.pixPos = anchor;
    KVScrollBar.obj.pos = 0;
    KVScrollBar.obj.stepping = stepping;
    
    KVScrollBar.obj.style.backgroundColor = "black";
    KVScrollBar.obj.style.fontSize = "1px";
    KVScrollBar.obj.style.position = "absolute";
    KVScrollBar.obj.style.left = (KVScrollBar.obj.vertical ? anchor2 : anchor) + "px";
    KVScrollBar.obj.style.top = (!KVScrollBar.obj.vertical ? anchor2 : anchor) + "px";
    KVScrollBar.actualizeBarSize(KVScrollBar.obj, length, view);
    if (!passive)
      KVScrollBar.obj.onmousedown = KVScrollBar.activate;
    KVScrollBar.obj.track.appendChild(KVScrollBar.obj);
    
    KVScrollBar.actualizeBarLimits(KVScrollBar.obj);
    
    KVScrollBar.obj.setPosition = function(p) {
      if (this.pos != (p = KVScrollBar.correctPosition(this, p))) {
        this.pos = p;
        KVScrollBar.posChanged = true;
        KVScrollBar.updatePixelPosition(this);
      }
    };
    
    KVScrollBar.obj.setView = function(newView) {
      if (newView < 0)
        newView = 0;
      if (newView > this.length)
        newView = this.length;
      KVScrollBar.actualizeBarSize(this, this.length, newView);
      KVScrollBar.actualizeBarLimits(this);
      this.setPosition(KVScrollBar.correctPosition(this, this.pos));
    };
    
    return KVScrollBar.obj;
  },
  
  actualizeBarSize: function(o, length, view) {
    if (!o.length || !o.view || o.length != length || o.view != view) {
      if (o.vertical) {
        o.style.width = (o.track.offsetWidth - o.anch2 * 2) + "px";
        o.style.height = Math.floor((o.track.offsetHeight - o.anch * 2) * view / length) + "px";
      } else {
        o.style.width = Math.floor((o.track.offsetWidth - o.anch * 2) * view / length) + "px";
        o.style.height = (o.track.offsetHeight - o.anch2 * 2) + "px";
      }
      o.length = length;
      o.view = view;
      
      if (KVScrollBar.onChange)
        KVScrollBar.onChange(o);
    }
  },
  
  actualizeBarLimits: function(o) {
    o.pixMin = o.anch;
    if (o.vertical)
      o.pixMax = o.track.offsetHeight - o.offsetHeight - o.anch;
    else
      o.pixMax = o.track.offsetWidth - o.offsetWidth - o.anch;
  },
  
  activate: function(e) {
    if (!e)
      e = window.event;
    
    KVScrollBar.obj = this;
    KVScrollBar.obj.activated = true;
    
    if (KVScrollBar.obj.vertical) {
      KVScrollBar.obj.initialClient = e.clientY;
      KVScrollBar.obj.initialOffset = parseInt(KVScrollBar.obj.style.top);
    } else {
      KVScrollBar.obj.initialClient = e.clientX;
      KVScrollBar.obj.initialOffset = parseInt(KVScrollBar.obj.style.left);
    }
    
    e.cancelBubble = true;
    
    KVScrollBar.bindEvent("mousemove", KVScrollBar.move);
    KVScrollBar.bindEvent("mouseup", KVScrollBar.deactivate);
    
    if (KVScrollBar.onStartShift)
      KVScrollBar.onStartShift(KVScrollBar.obj);
  },
  
  setPixelPosition: function(o, p) {
    if (o.vertical)
      o.style.top = p + "px";
    else
      o.style.left = p + "px";
  },
  
  correctPosition: function(o, p) {
    var result = p;
  
    if (result < 0)
      result = 0;
    if (result > o.length - o.view)
      result = o.length - o.view;
    
    return result;
  },
  
  correctPixelPosition: function(o) {
    if (o.pixPos < o.pixMin)
      o.pixPos = o.pixMin;
    if (o.pixPos > o.pixMax)
      o.pixPos = o.pixMax;
  },
  
  updatePixelPosition: function(o) {
    o.pixPos = Math.floor((o.pos * ((o.vertical ? o.track.offsetHeight : o.track.offsetWidth) - o.anch * 2 + 2)) / o.length) + o.anch;
    
    KVScrollBar.correctPixelPosition(o);
    KVScrollBar.setPixelPosition(o, o.pixPos);
    
    if (KVScrollBar.onChange && KVScrollBar.posChanged)
      KVScrollBar.onChange(o);
  },
  
  move: function(e) {
    if (KVScrollBar.obj.activated) {
      if (!e)
        e = window.event;
      
      KVScrollBar.obj.pixPos = KVScrollBar.obj.initialOffset + (KVScrollBar.obj.vertical ? e.clientY : e.clientX) - KVScrollBar.obj.initialClient;
      KVScrollBar.correctPixelPosition(KVScrollBar.obj);
      
      newPos = Math.floor((KVScrollBar.obj.pixPos - KVScrollBar.obj.anch) / (KVScrollBar.obj.pixMax - KVScrollBar.obj.anch) * (KVScrollBar.obj.length - KVScrollBar.obj.view) + 0.5);
      KVScrollBar.posChanged = false;
      if (newPos != KVScrollBar.obj.pos) {
        KVScrollBar.obj.pos = newPos;
        KVScrollBar.posChanged = true;
      }
      
      if (KVScrollBar.obj.stepping) {
        KVScrollBar.updatePixelPosition(KVScrollBar.obj);
        return false;
      }
      
      KVScrollBar.setPixelPosition(KVScrollBar.obj, KVScrollBar.obj.pixPos);
      
      if (KVScrollBar.onChange && KVScrollBar.posChanged)
        KVScrollBar.onChange(KVScrollBar.obj);
      
      return false;
    }
    
    return true;
  },
  
  deactivate: function(e) {
    KVScrollBar.obj.activated = false;
    
    KVScrollBar.releaseEvent("mousemove", KVScrollBar.move);
    KVScrollBar.releaseEvent("mouseup", KVScrollBar.deactivate);
    
    if (KVScrollBar.onEndShift)
        KVScrollBar.onEndShift(KVScrollBar.obj);
  },
  
  bindEvent: function(etype, fnc) {
    if (document.addEventListener)
      document.addEventListener(etype, fnc, true);
    else if (document.attachEvent)
      document.attachEvent("on" + etype, fnc);
  },
  
  releaseEvent: function(etype, fnc) {
    if (document.removeEventListener)
      document.removeEventListener(etype, fnc, true);
    else if (document.detachEvent)
      document.detachEvent("on" + etype, fnc);
  }
}
